#include <iostream.h>
#include <fstream.h>
#include <string.h>
#include <ctype.h>
#include <iomanip.h>
#include <stdio.h>  // rename();
#include <unistd.h> // unlink();

const int bucketSize = 2, tableSize = 3, strLen = 20;
const int recordLen = strLen;

class File {
public:
    File() : empty('*'), delMarker('#') {
    }
    void processFile(char*);
private:
    const char empty, delMarker;
    long *pointers;
    fstream outfile, overflow, sorted;
    unsigned long hash(char*);
    void swap(long& i, long& j) {
        long tmp = i; i = j; j = tmp;
    }
    void getName(char*);
    void insert(char line[]) {
        getName(line); insertion(line);
    }
    void insertion(char*);
    void remove(char*);
    void partition(int,int,int&);
    void QSort(int,int);
    void sortFile();
    void combineFiles();
};

unsigned long File::hash(char *s) {
    unsigned long xor = 0, pack;
    int i, j, slength; // usunicie spacji z koca;
    for (slength = strlen(s); isspace(s[slength-1]); slength--);
    for (i = 0; i < slength; ) {
        for (pack = 0, j = 0; ; j++, i++) {
            pack |= (unsigned long) s[i];     // wstaw s[i] do skrajnego prawego
            if (j == 3 || i == slength - 1) { // bajtu zmiennej pack;
                i++;
                break;
            }
            pack <<= 8;
        }             // zmiana 8 bajtw s za jednym razem;
        xor ^= pack;  // w ostatniej iteracji w pack moe
    }                 // zosta umieszczonych mniej ni 8 bajtw;
    return (xor % tableSize) * bucketSize * recordLen;
}// zwr pozycj waciwego kubeka dla s;

void File::getName(char line[]) {
    cout << "Podaj imi: ";
    cin.getline(line,recordLen+1);
    for (int i = strlen(line); i < recordLen; i++)
        line[i] = ' ';
    line[recordLen] = '\0';
}

void File::insertion(char line[]) {
    int address = hash(line), counter = 0;
    char name[recordLen+1];
    name[recordLen] = '\0';
    bool done = false, inserted = false;
    outfile.seekg(address,ios::beg);
    while (!done && outfile.getline(name,recordLen+1)) {
        if (name[0] == empty || name[0] == delMarker) {
             outfile.seekg(address+counter*recordLen,ios::beg);
             outfile << line << setw(strlen(line)-recordLen);
             done = inserted = true;
        }
        else if (!strcmp(name,line)) {
             cout << line << " ju jest w pliku\n";
             return;
        }
        else counter++;
        if (counter == bucketSize)
             done = true;
        else outfile.seekg(address+counter*recordLen,ios::beg);
    }
    if (!inserted) {
        done = false;
        counter = 0;
        overflow.clear();
        overflow.seekg(0,ios::beg);
        while (!done && overflow.getline(name,recordLen+1)) {
            if (name[0] == delMarker)
                 done = true;
            else if (!strcmp(name,line)) {
                 cout << line << " ju jest w pliku\n";
                 return;
            }
            else counter++;
        }
        overflow.clear();
        if (done)
             overflow.seekg(counter*recordLen,ios::beg);
        else overflow.seekg(0,ios::end);
        overflow << line << setw(strlen(line)-recordLen);
    }
}

void File::remove(char line[]) {
    getName(line);
    int address = hash(line), counter = 0;
    bool done = false, removed = false;
    char name2[recordLen+1];
    name2[recordLen] = '\0';
    outfile.clear();
    outfile.seekg(address,ios::beg);
    while (!done && outfile.getline(name2,recordLen+1)) {
        if (!strcmp(line,name2)) {
             outfile.seekg(address+counter*recordLen,ios::beg);
             outfile.put(delMarker);
             done = removed = true;
        }
        else counter++;
        if (counter == bucketSize)
             done = true;
        else outfile.seekg(address+counter*recordLen,ios::beg);
    }
    if (!removed) {
        done = false;
        counter = 0;
        overflow.clear();
        overflow.seekg(0,ios::beg);
        while (!done && overflow.getline(name2,recordLen+1)) {
            if (!strcmp(line,name2)) {
                 overflow.clear();
                 overflow.seekg(counter*recordLen,ios::beg);
                 overflow.put(delMarker);
                 done = removed = true;
            }
            else counter++;
            overflow.seekg(counter*recordLen,ios::beg);
        }
    }
    if (!removed)
        cout << line << " nie ma w bazie danych\n";
}

void File::partition (int low, int high, int& pivotLoc) {
    char rec[recordLen+1], pivot[recordLen+1];
    rec[recordLen] = pivot[recordLen] = '\0';
    register int i, lastSmall;
    swap(pointers[low],pointers[(low+high)/2]);
    outfile.seekg(pointers[low]*recordLen,ios::beg);
    outfile.getline(pivot,recordLen+1);
    for (lastSmall = low, i = low+1; i <= high; i++) {
        outfile.seekg(pointers[i]*recordLen,ios::beg);
        outfile.getline(rec,recordLen+1);
        if (strcmp(rec,pivot) < 0) {
            lastSmall++;
            swap(pointers[lastSmall],pointers[i]);
        }
    }
    swap(pointers[low],pointers[lastSmall]);
    pivotLoc = lastSmall;
}

void File::QSort(int low, int high) {
    int pivotLoc;
    if (low < high) {
        partition(low, high, pivotLoc);
        QSort(low, pivotLoc-1);
        QSort(pivotLoc+1, high);
    }
}

void File::sortFile() {
    char rec[recordLen+1];
    QSort(1,pointers[0]);   // pointers[0] zawiera ilo elementw;
    rec[recordLen] = '\0';  // sortowanie danych z pliku outfile
    for (int i = 1; i <= pointers[0]; i++) {       
        outfile.seekg(pointers[i]*recordLen,ios::beg);
        outfile.getline(rec,recordLen+1);
        sorted << rec << setw(strlen(rec)-recordLen);
    }
}

// dane z plikw outfile i overflow s zapisywane w pliku outfile 
// i przygotowywane do sortowania zewntrznego, w tym celu pozycje danych
// s wczytywane do tablicy

void File::combineFiles() {
    int counter = bucketSize*tableSize;
    char rec[recordLen+1];
    rec[recordLen] = '\0';
    outfile.seekg(0,ios::end);
    overflow.seekg(0,ios::beg);
    while (overflow.getline(rec,recordLen+1)) { // przeniesienie z pliku
        if (rec[0] != delMarker) {         // overflow do outfile jedynie
            counter++;                     // wanych (czyli nie usunitych) rekordw;
            outfile << rec << setw(strlen(rec)-recordLen);
        }
    }
    pointers = new long[counter+1];
    outfile.seekg(0,ios::beg);     // zapisanie w tablicy pointers pozycji 
    int arrCnt = 1;                // wanych danych przechowywanych w pliku wynikowym;
    for (int i = 0; i < counter; i++) {
        outfile.seekg(i*recordLen,ios::beg);
        outfile.getline(rec,recordLen+1);
        if (rec[0] != empty && rec[0] != delMarker)
            pointers[arrCnt++] = i;
    }
    pointers[0] = --arrCnt; // zapisanie iloci danych w komrce 0;
}

void File::processFile(char *fileName) {
    ifstream fIn(fileName);
    if (fIn.fail()) {
         cerr << "Nie mona otworzy " << fileName << endl;
         return;
    }
    char command[strLen] = "\0";
    outfile.open("outfile",ios::in|ios::out|ios::trunc);
    sorted.open("sorted",ios::in|ios::out|ios::trunc);
    overflow.open("overflow",ios::in|ios::out|ios::trunc);
    for (int i = 1; i <= tableSize*bucketSize*recordLen; i++) // inicjalizacja pliku
        outfile << empty;                                     // outfile;
    char line[recordLen+1];
    line[recordLen] = '\0';
    while (fIn.getline(line,recordLen+1)) // zapisanie zawartoci pliku wejciowego do wynikowego;
        insertion(line);
    while (strcmp(command,"exit")) {
        cout << "Wpisz polecenie (insert, remove, lub exit): ";
        cin.getline(command,strLen+1);
        if (!strcmp(command,"insert"))
             insert(line);
        else if (!strcmp(command,"remove"))
             remove(line);
        else if (strcmp(command,"exit"))
             cout << "Bdne polecenie, sprbuj jeszcze raz.\n";
    }
    combineFiles();
    sortFile();
    outfile.close();
    sorted.close();
    overflow.close();
    fIn.close();
    unlink(fileName);
    rename("sorted",fileName);
}

int main(int argc, char* argv[]) {
    char fileName[30];
    if (argc != 2) {
         cout << "Podaj nazw pliku: ";
         cin.getline(fileName,30);
    }
    else strcpy(fileName,argv[1]);
    File fClass;
    fClass.processFile(fileName);

	return 0;
}
