#include <iostream>
#include <fstream>
#include <ctype.h>
#include <stdlib.h>
#include <string>
#include <list>
#include <stack>
#include "genBST.h"

using namespace std;

class VertexArrayRec;
class LocalTree;
class Network;

class Vertex {
public:
    Vertex() {
    }
    Vertex(int id, int c, int ef, bool f, Vertex *t = 0) {
        idNum = id; capacity = c; edgeFlow = ef; forward = f; twin = t;
    }
    bool operator== (const Vertex& v) const {
        return idNum == v.idNum;
    }
    bool operator!= (const Vertex& v) const { // wymagane
        return idNum != v.idNum;
    }
    bool operator< (const Vertex& v) const {  // przez kompilator;
        return idNum < v.idNum;
    }
    bool operator> (const Vertex& v) const {
        return idNum > v.idNum;
    }
private:
    int idNum, capacity, edgeFlow;
    bool forward;       // kierunek;
    Vertex *twin;       // krawd w przeciwnym kierunku;
    friend Network;
    friend ostream& operator<< (ostream& out, const Vertex& vr) {
        out << vr.idNum  << ' ' << vr.capacity << ' ' << vr.edgeFlow << ' '
            << vr.forward << /*' ' << vr.twin << ' ' << &vr << */"| ";
        return out;
    }
};

class NetTreeNode {
public:
    NetTreeNode(VertexArrayRec **v = 0) {
        verticesPtr = v;
        adjacent = new list<Vertex>;
    }
    bool operator<  (const NetTreeNode& tr) const {
        return strcmp(idName,tr.idName) < 0;
    }
    bool operator== (const NetTreeNode& tr) const {
        return strcmp(idName,tr.idName) == 0;
    }
private:
    int idNum;
    char *idName;
    VertexArrayRec **verticesPtr;
    list<Vertex> *adjacent;
    friend Network;
    friend LocalTree;
    friend ostream& operator<< (ostream& out, const NetTreeNode& tr) {
        out << tr.idNum << ' ' << tr.idName << ' ';
        return out;
    }
};

class VertexArrayRec {
public:
    VertexArrayRec() {
        adjacent = 0;
    }                     
private:
    char *idName;
    int vertexSlack;
    bool labeled;
    int parent;
    Vertex *corrVer;        // odpowiadajcy wierzchoek: wierzchoek na licie
    list<Vertex> *adjacent; // ssiedztwa rodzica, dla ktrego 
    friend Network;         // idNum jest taki sam jak indeks komrki;
    friend LocalTree;
    friend ostream& operator<< (ostream&,const Network&);
};

// definicja nowej metody visit() ktra bdzie uywana przez 
// funkcj inorder() z pliku genBST.h;
class LocalTree : public BST<NetTreeNode> {
    void visit(BSTNode<NetTreeNode>* p) {
        (*(p->key.verticesPtr))[p->key.idNum].idName   = p->key.idName;
        (*(p->key.verticesPtr))[p->key.idNum].adjacent = p->key.adjacent;
    }
};

class Network {
public:
    Network() : sink(1), source(0), none(-1), numOfVertices(2) {
                verticesPtr = new VertexArrayRec*;
    }
    void readCommittees(char *committees);
    void FordFulkersonMaxFlow();
private:
    const int sink, source, none;
    int numOfVertices;
    VertexArrayRec *vertices; 
    VertexArrayRec **verticesPtr; // uywane przez visit() w LocalTree 
                                  // w celu aktualizowania wierzchokw
    int edgeSlack(Vertex *u) const {
        return u->capacity - u->edgeFlow;
    }
    int min(int n, int m) const {
        return n < m ? n : m;
    }
    bool Labeled(Vertex *v) const {
        return vertices[v->idNum].labeled;
    }
    void label(Vertex*,int);
    void augmentPath();
    friend LocalTree;
    friend ostream& operator<< (ostream& out, const Network& net) {
        ostream_iterator<Vertex> output(out," ");
        for (int i = 0; i < net.numOfVertices; i++) {
            out << i << ": " 
                << net.vertices[i].idName << '|'
                << net.vertices[i].vertexSlack << '|'
                << net.vertices[i].labeled << '|'
                << net.vertices[i].parent << '|'
                << /* net.vertices[i].corrVer << */ "-> ";
            if (net.vertices[i].adjacent != 0)
                 copy (net.vertices[i].adjacent->begin(),
                       net.vertices[i].adjacent->end(),output);
            out << endl;
		}
        return out;
    }
};

void Network::readCommittees(char *fileName) {
    char i, name[80], *s;
    bool lastMember;
    LocalTree committeeTree, memberTree;
    Vertex memberVer(0,1,0,false), commVer(0,1,0,true);
        Vertex *commVerAddr, *memberVerAddr;
    NetTreeNode committeeTreeNode(verticesPtr), memberTreeNode(verticesPtr), *member;
    list<Vertex> *sourceList = new list<Vertex>;
    ifstream fIn(fileName);
    if (fIn.fail()) {
        cerr << "Nie mona otworzy pliku: " << fileName << endl;
        exit(-1);
    }
    while (!fIn.eof()) {
        fIn >> name[0]; // pominicie pocztkowych spacji;
        if (fIn.eof())  // i spacji na kocu pliku;
             break;
        for (i = 0; name[i] != ':'; )
             name[++i] = fIn.get();
        for (i--; isspace(name[i]); i--); // odrzucenie kocowych spacji;
        name[i+1] = '\0';
        s = new char[strlen(name)+1];
        strcpy(s,name);
        committeeTreeNode.idNum  = commVer.idNum = numOfVertices++;
        committeeTreeNode.idName = s;
        for (lastMember = false; lastMember == false; ) {
            fIn >> name[0]; // pominicie pocztkowych spacji;
            for (i = 0; name[i] != ',' && name[i] != ';'; )
                name[++i] = fIn.get();
            if (name[i] == ';')
                lastMember = true;
            for (i--; isspace(name[i]); i--); // odrzucenie kocowych spacji;
            name[i+1] = '\0';
            s = new char[strlen(name)+1];
            strcpy(s,name);
            memberTreeNode.idName = s;
            commVer.forward = false;
            if ((member = memberTree.search(memberTreeNode)) == 0) {
                 memberVer.idNum = memberTreeNode.idNum = numOfVertices++;
                 memberTreeNode.adjacent->push_front(Vertex(sink,1,0,true));
                 memberTreeNode.adjacent->push_front(commVer);
                 commVerAddr = &*memberTreeNode.adjacent->begin();
                 memberTree.insert(memberTreeNode);
                 memberTreeNode.adjacent = new list<Vertex>;
            }
            else {
                 memberVer.idNum = member->idNum;
                 member->adjacent->push_front(commVer);
                 commVerAddr = &*member->adjacent->begin();
            }
            memberVer.forward = true;
            committeeTreeNode.adjacent->push_front(memberVer);
            memberVerAddr = &*committeeTreeNode.adjacent->begin();
            memberVerAddr->twin = commVerAddr;
            commVerAddr->twin = memberVerAddr;
        }
        commVer.forward = true;
        sourceList->push_front(commVer);
        committeeTree.insert(committeeTreeNode);
        committeeTreeNode.adjacent = new list<Vertex>;
    }
    fIn.close();
    vertices = *verticesPtr = new VertexArrayRec[numOfVertices];
    if (vertices == 0) {
        cerr << "Brak pamici\n";
        exit(-1);
    }
    vertices[source].idName = "source";
    vertices[sink].idName   = "sink";
    vertices[source].adjacent = sourceList;
    vertices[source].parent = none;
    committeeTree.inorder(); // przeniesienie danych z obu drzew 
    memberTree.inorder();    // do tablicy vertices[];
}

void Network::label(Vertex *u, int v) {
    vertices[u->idNum].labeled = true;
    if (u->forward)
         vertices[u->idNum].vertexSlack =
             min(vertices[v].vertexSlack,edgeSlack(u));
    else vertices[u->idNum].vertexSlack =
             min(vertices[v].vertexSlack,u->edgeFlow);
    vertices[u->idNum].parent  = v;
    vertices[u->idNum].corrVer = u;
}

void Network::augmentPath() {
    register int i, sinkSlack = vertices[sink].vertexSlack;
    Stack<char*> path;
	for (i = sink; i != source; i = vertices[i].parent) {
        path.push(vertices[i].idName);
        if (vertices[i].corrVer->forward)
             vertices[i].corrVer->edgeFlow += sinkSlack;
        else vertices[i].corrVer->edgeFlow -= sinkSlack;
        if (vertices[i].parent != source && i != sink)
             vertices[i].corrVer->twin->edgeFlow =
                vertices[i].corrVer->edgeFlow;
    }
    for (i = 0; i < numOfVertices; i++)
        vertices[i].labeled = false;
    cout << "  rdo";
    while (!path.empty())
        cout << " => " << path.pop();
    cout << " (powikszone przez " << sinkSlack << ");\n";
}

void Network::FordFulkersonMaxFlow() {
    register int i, v;
    Stack<int> labeled;
    Vertex *u;
	list<Vertex>::iterator it;
    for (i = 0; i < numOfVertices; i++) {
        vertices[i].labeled = false;
        vertices[i].vertexSlack = 0;  
        vertices[i].parent = none;   
    }
    vertices[source].vertexSlack = INT_MAX;
    labeled.push(source);
    cout << "Droga powikszajca:\n";
    while (!labeled.empty()) {   // dopki mona;
        v = labeled.pop();
        for (it = vertices[v].adjacent->begin(), u = &*it;
			 it != vertices[v].adjacent->end(); it++, u = &*it)
             if (!Labeled(u)) {
                 if (u->forward && edgeSlack(u) > 0)
                      label(u,v);
                 else if (!u->forward && u->edgeFlow > 0)
                      label(u,v);
                 if (Labeled(u))
                      if (u->idNum == sink) {
                           augmentPath();
                           while (!labeled.empty())
                               labeled.pop();	// wyczyszczenie stosu;
                           labeled.push(source);// szukamy nowej drogi;
						   break;
                      }
                      else {
                           labeled.push(u->idNum);
                           vertices[u->idNum].labeled = true;
                      }
             }
    }
}

int main(int argc, char* argv[]) {
    char fileName[30] = "";
    Network net;
    if (argc != 2) {
         cout << "Podaj nazw pliku: ";
         cin.getline(fileName,30);
    }
    else strcpy(fileName,argv[1]);
    net.readCommittees(fileName);
    cout << net;
    net.FordFulkersonMaxFlow();
    cout << net;

    return 0;
}
