#include <iostream>
#include <ctype.h>
#include <stdlib.h>
#include <vector>
#include <list>
#include <algorithm>

using namespace std;

class Variable {
public:
    char id;
    int exp;
    Variable() { // wymagane przez <vector>;
    }
    Variable(char c, int i) {
        id = c; exp = i;
    }
    bool operator== (const Variable& v) const { 
        return id  == v.id  && exp == v.exp;
    }
    bool operator< (const Variable& v) const { // wykorzystywane przez sort();
        return id < v.id;
    }
};

class Term {
public:
    Term() {
        coeff = 0;
    }
    int coeff;
    vector<Variable> vars;
    bool operator== (const Term&) const;
    bool operator!= (const Term& term) const { // wymagane przez <list>
        return !(*this == term);
    }
    bool operator< (const Term&) const;
    bool operator> (const Term& term) const {  // wymagane przez <list>
        return *this != term && (*this < term);
    }
    int min(int n, int m) const {
        return (n < m) ? n : m;
    }
};

class Polynomial {
public:
    Polynomial() {
    }
    Polynomial operator+ (Polynomial&);
    void error(char *s) {
        cerr << s << endl; exit(1);
    }
private:
    list<Term> terms;
    friend istream& operator>> (istream& in, Polynomial& polyn) {
        char ch, sign, coeffUsed, id;
        int exp;
        Term term;
        in >> ch;
        while (true) {
            coeffUsed = 0;
            if (!isalnum(ch) && ch != ';' && ch != '-' && ch != '+')
                 polyn.error("Wprowadzono zy znak");
            sign = 1;
            while (ch == '-' || ch == '+') { // najpierw jest pobierany znak
                 if (ch == '-')              // (znaki) wyrazu Term
                       sign *= -1;
                 ch = in.get();
                 if (isspace(ch))
                       in >> ch;
            }
            if (isdigit(ch)) {              // nastpnie jego wspczynnik;
                 in.putback(ch);
                 in >> term.coeff;
                 ch = in.get();
                 term.coeff *= sign;
                 coeffUsed = 1;
            }
            else term.coeff = sign;
	    int i;
            for (i = 0; isalnum(ch); i++) { // przetworzenie wyrazu:
                id = ch;                    // pobranie nazwy zmiennej
                ch = in.get();
                if (isdigit(ch)) {          // i jej wykadnika (jeli jest);
                     in.putback(ch);
                     in >> exp >> ch;
                }
                else exp = 1;
                term.vars.push_back(Variable(id,exp));
            }
            polyn.terms.push_back(term);    // dodanie wyrazu do listy;
            term.vars.resize(0);    
            if (isspace(ch))
                 in >> ch;
            if (ch == ';')                  // zakoczenie przetwarzania po odczytaniu;
                 if (coeffUsed || i > 0)    // znaku rednika
                      break;
                 else polyn.error("Brak wyrazu");  // np., 2x - ; lub tylko ';'
            else if (ch != '-' && ch != '+')       // np., 2x  4y;
                 polyn.error("Wpisano zy znak");
        }
        for (list<Term>::iterator it = polyn.terms.begin(); it != polyn.terms.end(); it++)
            if (it->vars.size() > 1)
                sort(it->vars.begin(),it->vars.end());
        return in;
    }

    friend ostream& operator<< (ostream& out, const Polynomial& polyn) {
        int afterFirstTerm = 0, i;
        for (list<Term>::const_iterator pol = polyn.terms.begin(); pol != polyn.terms.end(); pol++) {
            out.put(' ');
            if (pol->coeff < 0)             // umieszczenie '-' przed wielomianem
                 out.put('-');              // i pomidzy wyrazami (w razie koniecznoci);
            else if (afterFirstTerm)        // znak '+' nie jest umieszczany przed
                 out.put('+');              // wielomianem;
            afterFirstTerm++;
            if (abs(pol->coeff) != 1)       // wywietlenie wspczynnika
                 out << ' ' << abs(pol->coeff);// jeli jest on rny do 1 i -1, lub
            else if (pol->vars.size() == 0) // jeli wyraz skada si z samego wspczynnika
                 out << " 1";               
            else out.put(' ');
            for (i = 1; i <= pol->vars.size(); i++) {
                 out << pol->vars[i-1].id;       // wywietlenie nazwy zmiennej
                 if (pol->vars[i-1].exp != 1)    // i jej wykadnika, tylko w przypadku,
                      out << pol->vars[i-1].exp; // gdy jest on rny od 1;
            }
        }
        out << endl;
        return out;
    }
};

// dwa wyrazy s sobie rwne, jeli maj takie same zmienne
// oraz jeli wykadniki odpowiadajcych sobie zmiennych s takie same;
// podczas porwnywania nie jest uwzgldniana pierwsza komrka wza,
// gdy zawiera ona wspczynnik wyrazu;

bool Term::operator== (const Term& term) const {
    int i;
    for (i = 0; i < min(vars.size(),term.vars.size()) &&
                    vars[i] == term.vars[i]; i++);
    return i == vars.size() && vars.size() == term.vars.size();
}

bool Term::operator< (const Term& term2) const { // wykorzystywane przez sort();
    if (vars.size() == 0)
        return false;           // *this to tylko wspczynnik;
    else if (term2.vars.size() == 0)
        return true;            // term2 to tylko wspczynnik;
    for (int i = 0; i < min(vars.size(),term2.vars.size()); i++)
        if (vars[i].id < term2.vars[i].id)
             return true;       // *this poprzedza term2;
        else if (term2.vars[i].id < vars[i].id)
             return false;      // term2 poprzedza *this;
        else if (vars[i].exp < term2.vars[i].exp)
             return true;       // *this poprzedza term2;
        else if (term2.vars[i].exp < vars[i].exp)
             return false;      // term2 poprzedza *this;
    return ((int)vars.size() - (int)term2.vars.size() < 0) ? true : false;
}

Polynomial Polynomial::operator+ (Polynomial& polyn2) {
    Polynomial result;
    list<Term>::iterator p1, p2;
    bool erased;
    for (p1 = terms.begin(); p1 != terms.end(); p1++) // stworzenie nowego wielomianu
        result.terms.push_back(*p1);                  // z kopii *this
    for (p1 = polyn2.terms.begin(); p1 != polyn2.terms.end(); p1++) // oraz
        result.terms.push_back(*p1);                  // z kopii polyn2;
    for (p1 = result.terms.begin(); p1 != result.terms.end(); ) {
        for (p2 = p1, p2++, erased = false; p2 != result.terms.end(); p2++)
            if (*p1 == *p2) {             // jeli dwa wyrazy s rwne (za wyjtkiem
                 p1->coeff += p2->coeff;  // wspczynnikw), wspczynniki s dodawane
                 result.terms.erase(p2);  // a nadmiarowy wyraz zostaje usunity
                 if (p1->coeff == 0)      // jeli mnoznik w uzyskanym wyrazie 
                     result.terms.erase(p1);// ma warto zero,
                 erased = true;             // to take ten wyraz jest usuwany;
                 break;
            }
        if (erased)        // rozpoczcie przetwarzania od pocztku,
             p1 = result.terms.begin();  // jeli jaki wyraz zosta usunity;
        else p1++;
    }
    result.terms.sort();
    return result;
}

int main() {
    Polynomial polyn1, polyn2;
    cout << "Podaj dwa wielomiany zakoczone rednikami:\n";
    cin  >> polyn1 >> polyn2;
    cout << "Wyniki:\n" << polyn1 + polyn2;

	return 0;
}
