<Query Kind="Program" />

void Main()
{
	var numbers = new int [1000];
	for (int i = 0; i < numbers.Length; i++) numbers [i] = i;

	Sum (numbers).Dump ("suma - niejawna konwersja");
	Sum (numbers.AsSpan()).Dump ("total - using .AsSpan()");
	Sum (numbers.AsSpan (250, 500)).Dump ("suma - plasterkowanie");

	Span<int> span = numbers;
	Console.WriteLine (span [^1]);            // ostatni element
	Console.WriteLine (Sum (span [..10]));    // 10 pierwszych elementów
	Console.WriteLine (Sum (span [100..]));   // 100. elemnt od końca
	Console.WriteLine (Sum (span [^5..]));    // 5 ostatnich elementów
}

int Sum (ReadOnlySpan<int> numbers)
{
	int total = 0;
	foreach (int i in numbers) total += i;
	return total;
}