namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter22.Listing22_10
{
    using System;
    using System.Threading;
    using System.Threading.Tasks;

    public class Program
    {
        // Wyjaśnienie - pole inicjowane na początku funkcji Main
        #pragma warning disable CS8618 // Wyłączenie ostrzeżenia Niezainicjowane pole niedopuszczające wartości null; rozważ zadeklarowanie pola dopuszczającego null
        static ManualResetEventSlim MainSignaledResetEvent;
        static ManualResetEventSlim DoWorkSignaledResetEvent;
#pragma warning restore CS8618 // Wyłączenie ostrzeżenia Niezainicjowane pole niedopuszczające wartości null; rozważ zadeklarowanie pola dopuszczającego null

        public static void DoWork()
        {
            Console.WriteLine("Początek metody DoWork()....");
            DoWorkSignaledResetEvent.Set();
            MainSignaledResetEvent.Wait();
            Console.WriteLine("Koniec metody DoWork()....");
        }

        public static void Main()
        {
            using(MainSignaledResetEvent =
                new ManualResetEventSlim())
            using(DoWorkSignaledResetEvent =
                new ManualResetEventSlim())
            {
                Console.WriteLine(
                    "Uruchomiono aplikację...");
                Console.WriteLine("Uruchamianie wątku...");

                // W platformie .NET 4.0 zastosuj metodę Task.Factory.StartNew.
                Task task = Task.Run(() => DoWork());

                // Blokowanie prac do czasu uruchomienia metody DoWork().
                DoWorkSignaledResetEvent.Wait();
                Console.WriteLine(
                    " Oczekiwanie na wykonanie pracy przez wątek...");
                MainSignaledResetEvent.Set();
                task.Wait();
                Console.WriteLine("Zakończono pracę wątku");
                Console.WriteLine(
                    "Zamykanie aplikacji...");
            }
        }
    }
}
