namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter22.Listing22_07
{
    delegate void TemperatureChangedHandler(Program one, TemperatureEventArgs two);

    class Program
    {
        private static readonly TemperatureChangedHandler OnTemperatureChanged = delegate { };

        public void Main()
        {
            // Ten kod nie jest bezpieczny ze względu na wątki.
            if (OnTemperatureChanged != null) // Ostrzeżenie ignorowane, aby zilustrować problem
            {
                // Wywołanie kierowane do subskrybentów.
                OnTemperatureChanged(
                    this, new TemperatureEventArgs(value));
            }
        }

        #pragma warning disable IDE1006 // Wyłączenie ostrzeżenia dotyczącego nazewnictwa
        public object? value { get; set; }
#pragma warning restore IDE1006 // Wyłączenie ostrzeżenia dotyczącego nazewnictwa
    }

    class TemperatureEventArgs
    {
        public TemperatureEventArgs(object? _)
        {
            // ...
        }
    }
}
