namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter20.Listing20_04
{
    using System.IO;
    using System.Text;
    using System.Threading.Tasks;

    public static partial class Program
    {
        public static async ValueTask<byte[]> CompressAsync(byte[] buffer)
        {
            if (buffer.Length == 0)
            {
                return buffer;
            }
            using MemoryStream memoryStream = new MemoryStream();
            using System.IO.Compression.GZipStream gZipStream =
                new System.IO.Compression.GZipStream(
                    memoryStream, System.IO.Compression.CompressionMode.Compress);

            await gZipStream.WriteAsync(buffer, 0, buffer.Length);

            return memoryStream.ToArray();
        }

        public static string UnZip(string value)
        {
            // Przekształcanie z typu string na typ byte[]
            byte[] byteArray = new byte[value.Length];
            int index = 0;
            foreach (char item in value.ToCharArray())
            {
                byteArray[index++] = (byte)item;
            }

            using MemoryStream memoryStream = new MemoryStream(byteArray);
            using System.IO.Compression.GZipStream gZipStream = new System.IO.Compression.GZipStream(memoryStream,
                    System.IO.Compression.CompressionMode.Decompress);

             byteArray = new byte[byteArray.Length];

            // Wypakowywanie
            int bytesRead = gZipStream.Read(byteArray, 0, byteArray.Length);

            // Przekształcanie danych z typu byte[] na string
            StringBuilder data = new System.Text.StringBuilder(bytesRead);
            //Wczytywanie tylu bajtów, ile pobrano do gZipStream (zamiast wszystkich
            //bajtów z resultByteArray)
            for (int i = 0; i < bytesRead; i++)
            {
                data.Append((char)byteArray[i]);
            }
            return data.ToString();
        }
    }
}
