namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter18.Listing18_09
{
    using System;

    class CommandLineInfo
    {
        [CommandLineSwitchAlias("?")]
        public bool Help { get; set; }

        // Dwa możliwe rozwiązania
        //[CommandLineSwitchRequired]
        //[CommandLineSwitchAlias("FileName")]
        [CommandLineSwitchRequired,
        CommandLineSwitchAlias("FileName")]
        public string? Out { get; set; }

        public System.Diagnostics.ProcessPriorityClass Priority
            { get; set; } = 
                System.Diagnostics.ProcessPriorityClass.Normal;
    }

    internal class CommandLineSwitchRequiredAttribute : Attribute
    {
        // Bez implementacji
    }

    internal class CommandLineSwitchAliasAttribute : Attribute
    {
        public CommandLineSwitchAliasAttribute(string _)
        {
            // Bez implementacji
        }
    }

}
