using System;

namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter15.Listing15
{
    public class Department
    {
        public long Id { get; }
        public string Name { get; }
        public Department(string name, long id)
        {
            Id = id;
            Name = name ?? throw new ArgumentNullException(nameof(name));
        }
        public override string ToString()
        {
            return Name;
        }
    }

    public class Employee
    {
        public int Id { get; }
        public string Name { get; }
        public string Title { get; }
        public int DepartmentId { get; }
        public Employee(
            string name, string title, int departmentId)
        {
            Name = name ?? throw new ArgumentNullException(nameof(name));
            Title = title ?? throw new ArgumentNullException(nameof(title));
            DepartmentId = departmentId;
        }
        public override string ToString()
        {
            return $"{ Name } ({ Title })";
        }
    }

    public static class CorporateData
    {
        public static readonly Department[] Departments =
            new Department[]
        {
    new Department("Dział korporacyjny", 0),
    new Department("Dział finansów", 1),
    new Department("Dział inżynierii", 2),
    new Department("Dział IT", 3),
    new Department("Dział filantropii", 4),
    new Department("Dział marketingu", 5),
        };

        public static readonly Employee[] Employees = new Employee[]
        {
    new Employee("Mark Michaelis", "Główny nerd", 0),
    new Employee("Michael Stokesbary", "Starszy geniusz komputerowy", 2),
    new Employee("Brian Jones", "Guru od integracji systemów", 2),
    new Employee("Anne Beard", "Dyrektor działu kadr", 1),
    new Employee("Pat Dever", "Architekt systemów korporacyjnych", 3),
    new Employee("Kevin Bost", "Programista nadzwyczajny", 2),
    new Employee("Thomas Heavey", "Architekt oprogramowania", 2),
    new Employee("Eric Edmonds", "Koordynator działań charytatywnych", 4)
        };
    }
}
