﻿namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter09.Listing09_02
{
    // Używaj słowa kluczego struct do deklarowania typów bezpośrednich
    struct Angle
    {
        public Angle(int degrees, int minutes, int seconds)
        {
            Degrees = degrees;
            Minutes = minutes;
            Seconds = seconds;
        }

        // BŁĄD: pól nie można inicjować w ich deklaracji.
        // private int _Degrees = 42;

        public int Degrees { get; }

        public int Minutes { get; }
        public int Seconds { get; }

        public Angle Move(int degrees, int minutes, int seconds)
        {
            return new Angle(
                Degrees + degrees,
                Minutes + minutes,
                Seconds + seconds);
        }
    }

    // Deklarowanie typu referencyjnego - klasy (użycie
    // struktury spowoduje utworzenie typu bezpośredniego
    // większego niż 16 bajtów).
    class Coordinate
    {
        public Angle Longitude
        {
            get { return _Longitude; }
            set { _Longitude = value; }
        }
        private Angle _Longitude;

        public Angle Latitude
        {
            get { return _Latitude; }
            set { _Latitude = value; }
        }
        private Angle _Latitude;
    }
}