// Pole niedopuszczające null nie jest inicjowane; rozważ zadeklarowanie go jako dopuszczającego null
#pragma warning disable CS8618 

namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter06.Listing06_53
{
    using System;

    // Plik: Person.Designer.cs
    public partial class Person
    {
        #region Extensibility Method Definitions
        partial void OnLastNameChanging(string value);
        partial void OnFirstNameChanging(string value);
        #endregion

        // ...
        public string LastName
        {
            get
            {
                return _LastName;
            }
            set
            {
                if((_LastName != value))
                {
                    OnLastNameChanging(value);
                    _LastName = value;
                }
            }
        }
        private string _LastName;

        // ...
        public string FirstName
        {
            get
            {
                return _FirstName;
            }
            set
            {
                if(_FirstName != value)
                {
                    OnFirstNameChanging(value);
                    _FirstName = value;
                }
            }
        }
        private string _FirstName;

    }

    // Plik: Person.cs
    partial class Person
    {
        partial void OnLastNameChanging(string value)
        {
            if(value == null)
            {
                // W wersjach sprzed C# 6.0 użyj "value" zamiast nameof(value)
                throw new ArgumentNullException(nameof(value));
            }
            if(value.Trim().Length == 0)
            {
                throw new ArgumentException(
                "Argument LastName nie może być pusty.",
                    // W wersjach sprzed C# 6.0 użyj "value" zamiast nameof(value)
                    nameof(value));
            }
        }

        partial void OnFirstNameChanging(string value)
        {
            if(value == null)
            {
                // W wersjach sprzed C# 6.0 użyj "value" zamiast nameof(value)
                throw new ArgumentNullException(nameof(value));
            }
            if (value.Trim().Length == 0)
            {
                throw new ArgumentException(
                    "Argument FirstName nie może być pusty.",
                    // W wersjach sprzed C# 6.0 użyj "value" zamiast nameof(value)
                    nameof(value));

            }
        }
    }
}
