namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter06.Listing06_45
{
    using System;
    using static SimpleMath;

    public static class SimpleMath
    {
        // Słowo kluczowe params umożliwia podawanie różnej liczby parametrów.
        public static int Max(params int[] numbers)
        {
            // Sprawdzanie, czy w tablicy numbers znajduje się przynajmniej jeden element.
            if (numbers.Length == 0)
            {
                // W C# 6.0 zastąp "numbers" wyrażeniem nameof(numbers)
                throw new ArgumentException(
                    "Tablica numbers nie może być pusta", "numbers");
            }

            int result;
            result = numbers[0];
            foreach(int number in numbers)
            {
                if(number > result)
                {
                    result = number;
                }
            }
            return result;
        }

        // Słowo kluczowe params umożliwia podawanie różnej liczby parametrów
        public static int Min(params int[] numbers)
        {
            // Sprawdzanie, czy w tablicy numbers znajduje się przynajmniej jeden element
            if (numbers.Length == 0)
            {
                // W C# 6.0 zastąp "numbers" wyrażeniem nameof(numbers)
                throw new ArgumentException(
                    "Tablica numbers nie może być pusta", "numbers");
            }

            int result;
            result = numbers[0];
            foreach(int number in numbers)
            {
                if(number < result)
                {
                    result = number;
                }
            }
            return result;
        }
    }

    public class Program
    {
        public static void Main(string[] args)
        {
            int[] numbers = new int[args.Length];
            for (int count = 0; count < args.Length; count++)
            {
                numbers[count] = args[count].Length;
            }

            Console.WriteLine(
                $@"Długość najdłuższego argumentu = { Max(numbers) }");

            Console.WriteLine(
                $@"Długość najkrótszego argumentu = {
                    SimpleMath.Min(numbers) }");
        }
    }

}
