﻿// Pole niedopuszczające null nie jest zainicjowane. Rozważ deklarację pola dopuszczającego null
#pragma warning disable CS8618 
// Wyłączone, ponieważ nie wprowadzono jeszcze inicjalizatorów obiektów
#pragma warning disable IDE0017 

namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter06.Listing06_22
{
    public class Program
    {
        public static void Main()
        {
            Employee employee1 = new Employee();

            employee1.Name = "Inigo Montoya";
            System.Console.WriteLine(employee1.Name);

            // ...
        }
    }

    class Employee
    {
        // Właściwość FirstName
        public string FirstName
        {
            get
            {
                return _FirstName;
            }
            set
            {
                _FirstName = value;
            }
        }
        private string _FirstName;

        // Właściwość LastName
        public string LastName
        {
            get => _LastName;
            set => _LastName = value;
        }
        private string _LastName;
        // ...

        // Właściwość Name
        public string Name
        {
            get
            {
                return $"{ FirstName } { LastName }";
            }
            set
            {
                // Podział przypisanej wartości na 
                // imię i nazwisko.
                string[] names;
                names = value.Split(new char[] { ' ' });
                if(names.Length == 2)
                {
                    FirstName = names[0];
                    LastName = names[1];
                }
                else
                {
                    // Zgłaszanie wyjątku, jeśli nie
                    // przypisano imienia i nazwiska.
                    throw new System.ArgumentException(
                        $"Przypisana wartość '{ value }' jest nieprawidłowa",
                        nameof(value));
                }
            }
        }

        public string Initials => $"{ FirstName[0] } { LastName[0] }";

        // Właściwość Title
        public string? Title { get; set; }

        // Właściwość Manager
        public Employee? Manager { get; set; }
    }
}
