// Pole niedopuszczające null nie jest zainicjowane. Rozważ deklarację pola dopuszczającego null
#pragma warning disable CS8618

using System;

namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter06.Listing06_20
{
    public class Employee
    {
        // ...
        public void Initialize(
            string newFirstName, string newLastName)
        {
            // Używanie właściwości także wewnątrz 
            // klasy Employee.
            FirstName = newFirstName;
            LastName = newLastName;
        }

        // Właściwość LastName.
        public string LastName
        {
            get => _LastName;
            set
            {
                // Sprawdzanie poprawności w trakcie przypisywania wartości właściwości LastName.
                if (value == null)
                {
                    // Zgłaszanie błędu.
                    throw new ArgumentNullException(nameof(value));
                }
                else
                {
                    // Usuwanie odstępów wokół nazwiska.
                    value = value.Trim();
                    if(value == "")
                    {
                        throw new ArgumentException(
                            "Właściwość LastName nie może być pusta.", nameof(value));
                    }
                    else
                    {
                        _LastName = value;
                    }
                }
            }
        }
        private string _LastName;

        // Właściwość FirstName
        public string FirstName
        {
            get
            {
                return _FirstName;
            }
            set
            {
                // Sprawdzanie poprawności w trakcie przypisywania wartości właściwości FirstName
                if (value == null)
                {
                    // Zgłaszanie błędu.
                    // W wersji C# 6.0 należy zastąpić value wywołaniem nameof(value).
                    throw new ArgumentNullException("value");
                }
                else
                {
                    // Usuwanie odstępów wokół nowego imienia.
                    value = value.Trim();
                    if(value == "")
                    {
                        throw new ArgumentException(
                            // W wersjach starszych niż C# 6.0 użyj value zamiast
                            // nameof(value).
                            "Właściwość FirstName nie może być pusta.", nameof(value));
                    }
                    else
                    {
                        _FirstName = value;
                    }
                }
            }
        }
        private string _FirstName;
    }
}
