namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter06.Listing06_13
{
    // Dodanie przestrzeni nazw IO.
    using System.IO;
    using Listing06_12;

    public class DataStorage
    {
        // Zapis obiektu employee w pliku o nazwie
        // odpowiadającej imieniu i nazwisku pracownika.
        // Kod do obsługi błędów został pominięty.
        public static void Store(Employee employee)
        {
            // Tworzenie obiektu typu FileStream z nazwą pliku 
            // FirstNameLastName.dat. Parametr FileMode.Create powoduje 
            // utworzenie nowego pliku lub zastąpienie zawartości istniejącego.
            FileStream stream = new FileStream(
                employee.FirstName + employee.LastName + ".dat",
                FileMode.Create);

            // Tworzenie obiektu typu StreamWriter na potrzeby zapisu
            // tekstu w obiekcie typu FileStream.
            StreamWriter writer = new StreamWriter(stream);

            // Zapis wszystkich danych dotyczących pracownika.
            writer.WriteLine(employee.FirstName);
            writer.WriteLine(employee.LastName);
            writer.WriteLine(employee.Salary);

            // Zamyka obiekt typu StreamWriter i powiązany z nim strumień.
            writer.Dispose();  // Automatycznie zamyka strumień.
        }
        // ...
    }
}
