namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter04.Listing04_41
{
    public class BinaryConverter
    {
        public static void Main()
        {
            const int size = 64;
            ulong value;
            char bit;

            System.Console.Write("Wprowadź liczbę całkowitą: ");
            // Wywołanie long.Parse() pozwala dodać obsługę liczb ujemnych.
            // Kod bez sprawdzania przypisuje wartość do zmiennej typu ulong.
            value = (ulong)long.Parse(System.Console.ReadLine());

            // Ustawianie początkowej maski na 100.
            ulong mask = 1UL << size - 1;
            for (int count = 0; count < size; count++)
            {
                bit = ((mask & value) != 0) ? '1' : '0';
                System.Console.Write(bit);
                // Przesunięcie maski o jedną pozycję w prawo.
                mask >>= 1;
            }
            System.Console.WriteLine();
        }
    }
}
