namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter03.Listing03_28
{
    public class ProgrammingLanguages
    {
        public static void Main()
        {
            string[] languages = new string[]{
                "C#", "COBOL", "Java",
                "C++", "TypeScript", "Pascal",
                "Python", "Lisp", "JavaScript"};

            System.Array.Sort(languages);

            string searchString = "COBOL";
            int index = System.Array.BinarySearch(
                languages, searchString);
            System.Console.WriteLine(
      "Język przyszłości, "
      + $"{ searchString }, jest dostępny pod indeksem { index }.");

            System.Console.WriteLine();
            System.Console.WriteLine(
                $"{ "Pierwszy Element",-20 }\t{ "Ostatni Element",-20 }");
            System.Console.WriteLine(
                $"{ "-------------",-20 }\t{ "------------",-20 }");
            System.Console.WriteLine(
                    $"{ languages[0],-20 }\t{ languages[^1],-20 }");
            System.Array.Reverse(languages);
            System.Console.WriteLine(
                    $"{ languages[0],-20 }\t{ languages[^1],-20 }");
            // Zauważ, że poniższa instrukcja nie usuwa elementów z tablicy.
            // Zamiast tego do wszystkich elementów przypisywana jest wartość domyślna.
            System.Array.Clear(languages, 0, languages.Length);
            System.Console.WriteLine(
                    $"{ languages[0],-20 }\t{ languages[^1],-20 }");
            System.Console.WriteLine(
                $"Po wywołaniu Clear wielkość tablicy to: { languages.Length }");
        }
    }
}

