using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter03.Listing03_32.Tests
{
    [TestClass]
    public class PalindromeTests
    {
        [TestMethod]    
        public void Main_InputValidPalindrome_IdentifiedAsPalindrome()
        {
            const string expected =
@"Wprowadź palindrom: <<kayak
>>""kayak"" jest palindromem.";

            IntelliTect.TestTools.Console.ConsoleAssert.Expect(
                expected, Palindrome.Main);
        }
        
        [TestMethod]
        public void Main_InputInvalidPalindrome_NotIdentifiedAsPalindrome()
        {
            const string expected =
@"Wprowadź palindrom: <<test
>>""test"" NIE jest palindromem.";

            IntelliTect.TestTools.Console.ConsoleAssert.Expect(
                expected, Palindrome.Main);
        }
    }
}