using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter02.Listing02_29.Tests
{
    [TestClass]
    public class ProgramTests
    {
        [TestMethod]
        public void Main_TryParseStringValidNumber_CorrectlyParsed()
        {
            const string expected =
                @"Wprowadź liczbę: <<42>>";

            IntelliTect.TestTools.Console.ConsoleAssert.Expect(
                expected, Program.Main);
        }

        [TestMethod]
        public void Main_TryParseStringNonNumber_IncorrectInput()
        {
            const string expected =
@"Wprowadź liczbę: <<forty-two
>>Wprowadzony tekst nie jest poprawną liczbę.";

            IntelliTect.TestTools.Console.ConsoleAssert.Expect(
                expected, Program.Main);
        }
    }
}