namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter06.Listing06_50
{
    using System;

    public class Program
    {
        // Definiowanie klasy zagnieżdżonej służącej do przetwarzania wiersza poleceń.
        private class CommandLine
        {
            public CommandLine(string[] arguments)
            {
                for(int argumentCounter = 0;
                    argumentCounter < arguments.Length;
                    argumentCounter++)
                {
                    switch(argumentCounter)
                    {
                        case 0:
                            Action = arguments[0].ToLower();
                            break;
                        case 1:
                            Id = arguments[1];
                            break;
                        case 2:
                            FirstName = arguments[2];
                            break;
                        case 3:
                            LastName = arguments[3];
                            break;
                    }
                }
            }
            public string? Action { get;  }
            public string? Id { get; }
            public string? FirstName { get; }
            public string? LastName { get; }
        }

        public static void Main(string[] args)
        {
            CommandLine commandLine = new CommandLine(args);

            // Obsługa błędów celowo pominięta, aby kod był bardziej czytelny

            switch(commandLine.Action)
            {
                case "new":
                    // Tworzenie nowego obiektu reprezentującego pracownika.
                    Console.WriteLine("Tworzenie nowego obiektu typu Employee.");
                    break;
                case "update":
                    // Aktualizowanie danych w istniejącym obiekcie reprezentującym pracownika.
                    Console.WriteLine("Aktualizowanie nowego obiektu typu Employee.");
                    break;
                case "delete":
                    // Usuwanie pliku z danymi pracownika.
                    Console.WriteLine("Usuwanie nowego obiektu typu Employee.");
                    break;
                default:
                    Console.WriteLine(
                        "Employee.exe new|update|delete " +
                        "<id> [imię] [nazwisko]");
                    break;
            }
        }
    }
}
