namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter15.Listing15_07
{
    using System;

    public class Program
    {
        public static void Main()
        {
            System.Collections.Generic.Stack<int> stack =
                new System.Collections.Generic.Stack<int>();
            System.Collections.Generic.Stack<int>.Enumerator enumerator;
            IDisposable disposable;

            enumerator = stack.GetEnumerator();
            try
            {
                int number;
                while(enumerator.MoveNext())
                {
                    number = enumerator.Current;
                    Console.WriteLine(number);
                }
            }
            finally
            {
                // Jawne rzutowanie obiektu typu IEnumerator<T>.
                disposable = (IDisposable)enumerator;
                disposable.Dispose();

                // Dla obiektu typu IEnumerator należy zastosować operator as, chyba że
                // już w czasie kompilacji wiadomo, że obiekt obsługuje interfejs IDisposable.
                // disposable = (enumerator as IDisposable);
                // if (disposable != null)
                // {
                //     disposable.Dispose();
                // }
            }
        }
    }
}
