namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter09.Listing09_17
{
    using System;
    using System.IO;

    public class Program
    {
        public static void Main()
        {
            string fileName = @"enumtest.txt";

            // Porządkowanie w sytuacji, gdy plik jest tylko do odczytu
            // i nie można go utworzyć.
            if (File.Exists(fileName))
            {
                FileAttributes attrs = File.GetAttributes(fileName);
                if (attrs.HasFlag(FileAttributes.ReadOnly))
                    File.SetAttributes(fileName, attrs & ~FileAttributes.ReadOnly);
            }

            FileInfo file = new FileInfo(fileName);

            file.Open(FileMode.OpenOrCreate).Dispose();

            FileAttributes startingAttributes =
                file.Attributes;

            file.Attributes = FileAttributes.Hidden |
                FileAttributes.ReadOnly;

            Console.WriteLine("\"{0}\" wyświetlane jako \"{1}\"",
                file.Attributes.ToString().Replace(",", " |"),
                file.Attributes);

            FileAttributes attributes =
                (FileAttributes)Enum.Parse(typeof(FileAttributes),
                file.Attributes.ToString());

            Console.WriteLine(attributes);

            File.SetAttributes(fileName,
                startingAttributes);

            file.Delete();
        }
    }
}
