﻿// Wyłączone, ponieważ nie wprowadzono jeszcze inicjalizatorów obiektów
#pragma warning disable IDE0017 

namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter06.Listing06_26
{
    public class Program
    {
        public static void Main()
        {
            Employee employee;
            employee = new Employee("Inigo", "Montoya");
            employee.Salary = "Za niskie";

            System.Console.WriteLine(
                "{0} {1}: {2}",
                employee.FirstName,
                employee.LastName,
                employee.Salary);
        }
    }

    class Employee
    {
        // Konstruktor w klasie Employee.
        public Employee(string firstName, string lastName)
        {
            FirstName = firstName;
            LastName = lastName;
        }

        public string FirstName { get; set; }
        public string LastName { get; set; }
        public string? Salary { get; set; } = "Za niskie";
        public string? Title { get; set; }
        public Employee? Manager { get; set; }

        // Właściwość Name
        public string Name
        {
            get
            {
                return FirstName + " " + LastName;
            }
            set
            {
                // Podział przypisanej wartości na 
                // imię i nazwisko.
                string[] names;
                names = value.Split(new char[] { ' ' });
                if(names.Length == 2)
                {
                    FirstName = names[0];
                    LastName = names[1];
                }
                else
                {
                    // Zgłaszanie wyjątku, jeśli nie
                    // przypisano imienia i nazwiska.
                    throw new System.ArgumentException(
                        string.Format(
                        $"Przypisana wartość '{ value }' jest nieprawidłowa", 
                        nameof(value)));
                }
            }
        }
    }
}
