namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter04.Listing04_62
{
    public class Program
    {
        public static void Main()
        {
            // ...

            int border;
            string[] borders = {
                "|", "|", "\n---+---+---\n", "|", "|",
                "\n---+---+---\n", "|", "|", ""
            };
            System.Collections.Generic.IEnumerable<char> cells  = new char []{
                '1', '2', '3', '4', '5', '6', '7', '8', '9'
            };


            #region Wyświetlanie planszy do gry w kółko i krzyżyk

#if CSHARP2PLUS
            System.Console.Clear();
#endif

            // Wyświetlanie obecnego stanu planszy.
            border = 0;  // Pozwala dodać pierwszą linię pionową (border[0] = "|")

            // Wyświetlanie górnej linii kresek. 
            // ("\n---+---+---\n")
            System.Console.Write(borders[2]);
            foreach (char cell in cells)
            {
                // Wyświetlanie wartości komórki i pionowej kreski.
                System.Console.Write($" { cell } { borders[border] }");

                // Inkrementacja w celu przejścia do następnej kreski.
                border++;

                // Ustawianie zmiennej border na 0, jeśli border jest równe 3.
                if (border == 3)
                {
                    border = 0;
                }
            }

            #endregion Wyświetlanie planszy do gry w kółko i krzyżyk

            // ...
        }
    }
}
