namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter04.Listing04_37
{
    public class Program
    {
        public static void Main(params string[] args)
        {

            string[]? segments = null;

            // Pominięte w tekście, ponieważ w typowej metodzie Main args jest różne od null.
            segments = args;

            string? uri = null;

            int? length = segments?.Length;
            if (length is { } && length != 0)
            {
                uri = string.Join('/', segments!);
            }

            // Operator ? i akcesor tablicy 
            // uri = segments?[0];


            if (uri is null || length is 0)
            {
                System.Console.WriteLine(
                    "Brak elementów do połączenia.");
            }
            else
            {
                System.Console.WriteLine(
                    $"Uri: { uri }");
            }
        }
    }
}
