namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter22.Listing22_08
{
    delegate void TemperatureChangedHandler(Program one, TemperatureEventArgs two);

    class Program
    {
        private static TemperatureChangedHandler OnTemperatureChanged = delegate { };

        public void Main()
        {

#if(!PreCSharp6)
            OnTemperatureChanged?.Invoke(
                this, new TemperatureEventArgs(value));
#else
            TemperatureChangedHandler localOnChange =
                OnTemperatureChanged;
            if(localOnChange != null)
            {
                // Wywołanie kierowane do subskrybentów.
                localOnChange(
                  this, new TemperatureEventArgs(value));
            }
#endif
        }

        // Wyjaśnienie - małe litery, aby zasymulować słowo kluczowe value.
#pragma warning disable IDE1006 // Wyłączenie ostrzeżenia dotyczącego nazewnictwa
        public object? value { get; set; }
#pragma warning restore IDE1006 // Wyłączenie ostrzeżenia dotyczącego nazewnictwa
    }

    class TemperatureEventArgs
    {
        public TemperatureEventArgs(object? _)
        {
            // ...
        }
    }
}
