namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter15.Listing15_16
{
    using AddisonWesley.Michaelis.EssentialCSharp.Chapter15.Listing15;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    public class Program
    {
        public static void Main()
        {
            IEnumerable<Patent> patents = PatentData.Patents;
            bool result;
            patents = patents.Where(
                patent =>
                {
                    if(result =
                        patent.YearOfPublication.StartsWith("18"))
                    {
                        // Efekty uboczne w predykacie 
                        // służą tu do zademonstrowania reguł języka.
                        // Zwykle należy unikać pisania takiego kodu.
                        Console.WriteLine("\t" + patent);
                    }
                    return result;
                });

            Console.WriteLine("1. Patenty sprzed 1900 roku:");
            foreach(Patent patent in patents)
            {
            }

            Console.WriteLine();
            Console.WriteLine(
                "2. Druga lista patentów sprzed 1900 roku:");
            Console.WriteLine(
                $@"   Liczba patentów sprzed 1900 roku to: {patents.Count()}.");


            Console.WriteLine();
            Console.WriteLine(
                "3. Trzecia lista patentów sprzed 1900 roku:");
            patents = patents.ToArray();
            Console.Write("   Liczba patentów sprzed 1900 roku to: ");
            Console.WriteLine(
                $"{ patents.Count() }.");
        }
    }
}
