﻿namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter14.Listing14_01
{
    class Cooler
    {
        public Cooler(float temperature)
        {
            Temperature = temperature;
        }

        // Chłodnica jest uruchamiana, gdy temperatura przekracza określony poziom.
        public float Temperature { get; set; }

        // Powiadamianie o zmianie temperatury w danym obiekcie.
        public void OnTemperatureChanged(float newTemperature)
        {
            if(newTemperature > Temperature)
            {
                System.Console.WriteLine("Chłodnica: włączona");
            }
            else
            {
                System.Console.WriteLine("Chłodnica: wyłączona");
            }
        }
    }

    class Heater
    {
        public Heater(float temperature)
        {
            Temperature = temperature;
        }

        // Grzejnik jest uruchamiany, gdy temperatura spada poniżej określonego poziomu.
        public float Temperature { get; set; }

        // Powiadamianie o zmianie temperatury w danym obiekcie.
        public void OnTemperatureChanged(float newTemperature)
        {
            if(newTemperature < Temperature)
            {
                System.Console.WriteLine("Grzejnik: włączony");
            }
            else
            {
                System.Console.WriteLine("Grzejnik: wyłączony");
            }
        }
    }
}