﻿namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter09.Listing09_03
{
    // Słowo kluczowe struct deklaruje typ bezpośredni
    struct Angle
    {
        // BŁĄD: obiektu 'this' nie można użyć przed
        //      przypisaniem wartości do wszystkich jego pól.
        // public Angle(int degrees, int minutes, int seconds)
        // {
        //     Degrees = degrees;    // Skrót od this.Hours = hours;
        //     Minutes = minutes; // Skrót od this.Minutes = ...;
        //     Seconds = seconds; // Skrót od this.Seconds = ...;
        // }

        public Angle(int degrees, int minutes, int seconds)
        {
            _Degrees = degrees; // Skrót od this.Degrees = ...;
            _Minutes = minutes; // Skrót od this.Minutes = ...;
            _Seconds = seconds; // Skrót od this.Seconds = ...;
        }

        public int Degrees { get { return _Degrees; } }
        readonly private int _Degrees;

        public int Minutes { get { return _Minutes; } }
        readonly private int _Minutes;

        public int Seconds { get { return _Seconds; } }
        readonly private int _Seconds;

        public Angle Move(int degrees, int minutes, int seconds)
        {
            return new Angle(
                Degrees + degrees,
                Minutes + minutes,
                Seconds + seconds);
        }
    }

    // Deklarowanie klasy (typu referencyjnego).
    // Użycie struktury spowoduje utworzenie typu bezpośredniego
    // większego niż 16 bajtów.
    class Coordinate
    {
        public Angle Longitude
        {
            get { return _Longitude; }
            set { _Longitude = value; }
        }
        private Angle _Longitude;

        public Angle Latitude
        {
            get { return _Latitude; }
            set { _Latitude = value; }
        }
        private Angle _Latitude;
    }
}