namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter04.Listing04_50
{
    public class TicTacToe  // Deklaracja klasy TicTacToe. 
    {
        public static void Main() // Deklaracja punktu wejścia do programu.
        {
            int winner = 0;
            // Przechowuje pola wybrane przez poszczególnych graczy.
            int[] playerPositions = { 0, 0 };

            // Zapisanie na sztywno pozycji na planszy.
            // X  |  2  | O 
            // ---+---+---
            // O  | O  | 6 
            // ---+---+--- 
            // X  |  X  | X
            playerPositions[0] = 449;
            playerPositions[1] = 28;

            // Wykrywanie wygranej jednego z graczy.
            int[] winningMasks = {
      7, 56, 448, 73, 146, 292, 84, 273 };

            // Sprawdzenie wszystkich masek oznaczających wygraną, by 
            // ustalić, czy któryś z graczy zwyciężył.
            foreach (int mask in winningMasks)
            {
                if ((mask & playerPositions[0]) == mask)
                {
                    winner = 1;
                    break;
                }
                else if ((mask & playerPositions[1]) == mask)
                {
                    winner = 2;
                    break;
                }
            }

            System.Console.WriteLine(
              $"Zwyciężył gracz nr { winner }");
        }
    }

}