﻿namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter03.Table03_01
{
    public class TupleDeclarationAndAssigment
    {
        // 1.
        public void AssignTupleToIndividuallyDeclaredVaraibles()
        {
            (string country, string capital, double gdpPerCapita) =
                ("Sudan Południowy", "Juba", 275.18);
            System.Console.WriteLine(
                $@"Najbiedniejszym krajem w 2019 r. był {
                    country}, {capital}: {gdpPerCapita}");
        }

        // 2.
        public void AssignTupleToIndividuallyDeclaredVariablesThatArPreDeclared()
        {
            string country;
            string capital;
            double gdpPerCapita;

            (country, capital, gdpPerCapita) =
                ("Sudan Południowy", "Juba", 275.18);
            System.Console.WriteLine(
                $@"Najbiedniejszym krajem w 2019 r. był {
                    country}, {capital}: {gdpPerCapita}");
        }

        // 3.
        public void AssignTupleToIndividuallyDeclaredAndImplicitlyTypedVariables()
        {
            (var country, var capital, var gdpPerCapita) =
                ("Sudan Południowy", "Juba", 275.18);
            System.Console.WriteLine(
                $@"Najbiedniejszym krajem w 2019 r. był {
                    country}, {capital}: {gdpPerCapita}");
        }

        // 4.
        public void AssignTupleToIndividuallyDeclaredVariablesThatImplicitlyTypedWithADistributiveSyntax()
        {
            var (country, capital, gdpPerCapita) =
                ("Sudan Południowy", "Juba", 275.18);
            System.Console.WriteLine(
                $@"Najbiedniejszym krajem w 2019 r. był {
                    country}, {capital}: {gdpPerCapita}");
        }

        // 5.
        public void DeclareANamedItemTupleAndAssignItTupleValuesAndThenAccessTheTupleItemsByName()
        {
            (string Name, string Capital, double GdpPerCapita) countryInfo =
                ("Sudan Południowy", "Juba", 275.18);
            System.Console.WriteLine(
                $@"Najbiedniejszym krajem w 2019 r. był {
                    countryInfo.Name}, {countryInfo.Capital}: {
                    countryInfo.GdpPerCapita}");
        }

        // 6.
        public void AssignANamedItemTupleToASingleImplicitlyTypedVariableThatIsImplicitlyTypedAndThenAccessTheTupleItemsByName()
        {
            var countryInfo =
                (Name: "Sudan Południowy", Capital: "Juba", GdpPerCapita: 275.18);
            System.Console.WriteLine(
              $@"Najbiedniejszym krajem w 2019 r. był {
              countryInfo.Name}, {countryInfo.Capital}: {
              countryInfo.GdpPerCapita}");

        }

        // 7.
        public void AssignAnUnnamedTupleToASingleImplicitlyTypedVariableAndThenAccessTheTupleElementsByTheirItemNumberProperty()
        {
            var countryInfo =
                ("Sudan Południowy", "Juba", 275.18);
            System.Console.WriteLine(
              $@"Najbiedniejszym krajem w 2019 r. był {
              countryInfo.Item1}, {countryInfo.Item2}: {
              countryInfo.Item3}");
        }

        // 8.
// Wyjaśnienie - ilustruje to, że name jest aliasem dla ItemX.
#pragma warning disable IDE0033 // Używanie bezpośrednio podanej nazwy krotki
        public void AssignANamedItemTupleToASingleImplicitlyTypedVariableAndThenAccessTheTupleItemsByTheirItemNumberProperty()
        {
            var countryInfo =
                (Name: "Sudan Południowy", Capital: "Juba", GdpPerCapita: 275.18);
            System.Console.WriteLine(
              $@"Najbiedniejszym krajem w 2019 r. był {
              countryInfo.Item1}, {countryInfo.Item2}: {
              countryInfo.Item3}");
        }
#pragma warning restore IDE0033 // Używanie bezpośrednio podanej nazwy krotki

        // 9.
        public void DiscardPortionsOfTheTupleWithUnderscores()
        {
            (string name, _, double gdpPerCapita) =
                ("Sudan Południowy", "Juba", 275.18);
        }

        // 10.
        public void TupleElementNamesCanBeInferredFromVariableAndPropertyNames()
        {
            string country = "Sudan Południowy";
            string capital = "Juba";
            double gdpPerCapita = 275.18;

            var countryInfo =
                (country, capital, gdpPerCapita);
            System.Console.WriteLine(
                $@"Najbiedniejszym krajem w 2019 r. był {
                    countryInfo.country}, {countryInfo.capital}: {
                    countryInfo.gdpPerCapita}");
        }
    }
}
