namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter17.Listing17_10
{
    using System;

    // ----

    interface IPair<T>
    {
        T First { get; }

        T Second { get; }

        T this[PairItem index] { get; }
    }

    // ----

    public enum PairItem
    {
        First,
        Second
    }

    // ----

    public struct Pair<T> : IPair<T>
    {
        public Pair(T first, T second)
        {
            First = first;
            Second = second;
        }

        public T First { get; } // Automatycznie generowana właściwość z samym getterem (z wersji C# 6.0). 

        public T Second { get; } // Automatycznie generowana właściwość z samym getterem (z wersji C# 6.0). 

        [System.Runtime.CompilerServices.IndexerName("Entry")]
        public T this[PairItem index]
        {
            get
            {
                return index switch
                {
                    PairItem.First => First,
                    PairItem.Second => Second,
                    _ => throw new NotImplementedException(
                         $"Wyliczenie nie zawiera wartości { index }."),
                };
            }
        }
    }
}
