﻿namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter14.Listing14_06
{
    using System;

    public class Thermostat
    {
        // Definicja metody publikującej zdarzenia
        public Action<float>? OnTemperatureChange { get; set; }

        public float CurrentTemperature
        {
            get { return _CurrentTemperature; }
            set
            {
                if(value != CurrentTemperature)
                {
                    _CurrentTemperature = value;
                    // Jeśli istnieją subskrybenci,
                    // należy ich powiadomić o zmianach temperatury
                    // za pomocą skierowanego do nich wywołania.
#pragma warning disable IDE1005 // Można uprościć wywołanie delegata
                    Action<float>? localOnChange =
                        OnTemperatureChange;
                    if(localOnChange != null)
                    {
                        // Wywołanie skierowane do subskrybentów.
                        localOnChange(value);
                    }
#pragma warning restore IDE1005 // Można uprościć wywołanie delegata
                }
            }
        }

        private float _CurrentTemperature;
    }
}