﻿// Wyjaśnienie - błędny kod w komentarzach wynika z niekompletnej implementacji
#pragma warning disable IDE0059 // Niepotrzebne przypisanie wartości

namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter07.Listing07_07
{
    using System;
    using System.IO;

    public class PdaItem
    {
        public PdaItem(Guid objectKey) => ObjectKey = objectKey;
        protected Guid ObjectKey { get; }
    }

    public class Contact : PdaItem
    {
        public Contact(Guid objectKey)
            : base(objectKey) { }

        public void Save()
        {
            // Tworzenie obiektu typu FileStream z nazwą pliku
            // w formacie <ObjectKey>.dat.
            using FileStream stream = File.OpenWrite(
                ObjectKey + ".dat");
            // ...
            stream.Dispose();
        }
        static public Contact Copy(Contact contact)
            => new Contact(contact.ObjectKey);

        // static public Contact Copy(PdaItem pdaItem) =>
        // Błąd: brak dostępu do chronionej składowej PdaItem.ObjectKey.
        // new Contact(((Contact)pdaItem).ObjectKey);
    }

    public class Program
    {
        public static void Main()
        {
            Contact contact = new Contact(Guid.NewGuid());

            // BŁĄD: właściwość 'PdaItem.ObjectKey' jest niedostępna
            // Console.WriteLine(contact.ObjectKey);
        }
    }
}
