
namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter06.Listing06_36
{
    using System.Diagnostics.CodeAnalysis;

    public class NullabilityAttributesExamined
    {
        static public bool TryGetDigitAsText(
            char number, [NotNullWhen(true)]out string? text) =>
                (text = number switch
                {
                    '1' => "jeden",
                    '2' => "dwa",
                    '3' => "trzy",
                    '4' => "cztery",
                    // ...
                    '9' => "dziewięć",
                    _ => null
                }) is string;

        [return: NotNullIfNotNull("text")]
        static public string? TryGetDigitsAsText(string? text)
        {
            if (text == null) return null;

            string result = "";
            foreach (char character in text)
            {
                if (TryGetDigitAsText(character, out string? digitText))
                {
                    if (result != "") result += '-';
                    result += digitText.ToLower();
                }
            }
            return result;
        }
    }
}
