using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter05.Listing05_28.Tests
{
    [TestClass]
    public class LeveragingTryParseTests
    {
        public static int OutValue = 0;
        
        [TestMethod]
        public void Main_InputNameAndAge35_AgeProperlyParsed()
        {
            const string expected =
@"Wprowadź imię: <<Inigo
>>Wprowadź wiek: <<36
>>Hej, Inigo! Twój wiek w miesiącach to 432.";

            IntelliTect.TestTools.Console.ConsoleAssert.Expect(expected, 
                LeveragingTryParse.Main);
        }

        [TestMethod]
        public void Main_InputNameAndAgeThirtyFive_AgeNotParsed()
        {
            const string expected =
@"Wprowadź imię: <<Inigo
>>Wprowadź wiek: <<ThirtyFive
>>Wprowadzony wiek, ThirtyFive, nie jest prawidłowy.";

            IntelliTect.TestTools.Console.ConsoleAssert.Expect(
                expected, LeveragingTryParse.Main);
        }
    }
}