using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter04.Listing04_53
{
    [TestClass]
    public class EmailDomainTests
    {
        [TestMethod]
        public void Main_EnterValidEmailWithDomain_WriteDomain()
        {
            const string expected =
@"Wprowadź adres e-mail: 
<<First.Last@domain.com
>>Domena podanego adresu to: domain.com";

            IntelliTect.TestTools.Console.ConsoleAssert.Expect(
                expected, EmailDomain.Main);
        }
        
        [TestMethod]
        public void Main_EnterInvalidEmailWithoutDomain_WriteBlank()
        {
            const string expected =
@"Wprowadź adres e-mail:
<<First.Last
>>Domena podanego adresu to: ";

            IntelliTect.TestTools.Console.ConsoleAssert.Expect(
                expected, EmailDomain.Main);
        }
    }
}