﻿using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;

namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter02.Listing02_30.Tests
{
    [TestClass]
    public class ProgramTests
    {
        [TestMethod]
        public void Main_UsingTryParseWithInlineOut_Pi()
        {
            string expected = $"Wprowadź liczbę: <<{System.Math.PI}>>Wprowadzony tekst został poprawnie przekształcony na liczbę {System.Math.PI}.>>{Environment.NewLine}'number' ma teraz wartość: { System.Math.PI }";

            IntelliTect.TestTools.Console.ConsoleAssert.Expect(
                expected, Program.Main);

        }

        [TestMethod]
        public void Main_UsingTryParseWithInlineOut_Pie()
        {
            string expected = @$"Wprowadź liczbę: <<pie>>Wprowadzony tekst nie jest poprawną liczbą.
'number' ma teraz wartość: { default(int) }";
            IntelliTect.TestTools.Console.ConsoleAssert.Expect(
                expected, Program.Main);

        }
    }
}