# EssentialCSharp

Projekt zawiera kod do książki **C# 8.0. Kompletny przewodnik dla praktyków**, autor Mark Michaelis (Addison-Wesley/Helion).

## Wskazówki dotyczace przykładowego kodu

Upewnij się, że zainstalowana jest najnowsza wersja jednej z następujących platform.

* [.NET Framework](https://www.microsoft.com/net/targeting) (Windows)
* [.NET Core](https://www.microsoft.com/net/core) (wszystkie systemy)

[Visual Studio 2019](https://www.visualstudio.com) zawiera środowisko uruchomieniowe .NET Framework, a także umożliwia instalację .NET Core. Nie wspominając nawet, że jest to świetne IDE ułatwiające rozpoczęcie pracy.

### Pobieranie kodu

#### Kopia lokalna

Otwórz konsolę i zmień katalog roboczy na docelową lokalizację projektu. 
```
$ git clone https://github.com/IntelliTect/EssentialCSharp.git
$ cd ./EssentialCSharp/
```

Ten kod źródłowy dotyczy najnowszego wydania książki. Jest to gałąź domyślna w instrukcji clone. Możesz jednak wybrać inną gałąź, np. v6.0, używając polecenia:
```
$ git checkout v6.0
```

Spolszczona wersja jest dostępna w witrynie wydawnictwa Helion.

### Kompilacja

**EssentialCSharp.sln** to główne rozwiązanie projektu. Otwórz je w Visual Studio i wybierz opcję Kompiluj rozwiązanie.
 
 Jeśli używasz wiersza poleceń, zbuduj wszystkie projekty z katalogu /EssentialCSharp/ za pomocą poleceń:
```
$ dotnet restore EssentialCSharp.sln
$ dotnet build EssentialCSharp.sln
```
 
### Uruchamianie

Przejdź do projektu w katalogu /EssentialCSharp/src/(projekt)/ i uruchom kod. 
Ten przykład dotyczy rozdziału 1., a użytkownik wpisuje 1.1, aby uruchomić wybrany listing.

Aby uruchomić listing, musisz wykonać zawierający go projekt. Na przykład w celu wykonania listingu 1.1
musisz przejść do katalogu Chapter01 w Eksploratorze rozwiązań i ustawić Chapter01 jako projekt startowy.
W środowisku Rider znajdź projekt w zakładce Explorer, kliknij go prawym przyciskiem myszy i wybierz Run.

```
$ cd ./src/Chapter01/
$ dotnet run
Podaj numer listingu do wykonania (np. dla listingu 1.1 wpisz "1.1"): 1.1

____________________________

Witaj. Nazywam się Inigo Montoya.

____________________________
Koniec listingu 01_01
Wciśnij dowolny klawisz, aby kontynuować.
$
```

Dokumentację narzędzi z rodziny .NET CLI znajdziesz tu: 

https://docs.microsoft.com/en-us/dotnet/core/tools/


