string clientExe = "d:\PipeDemo\ClientDemo.exe";

HandleInheritability inherit = HandleInheritability.Inheritable;

using (var tx = new AnonymousPipeServerStream (PipeDirection.Out, inherit))
using (var rx = new AnonymousPipeServerStream (PipeDirection.In, inherit))
{
  string txID = tx.GetClientHandleAsString();
  string rxID = rx.GetClientHandleAsString();

  var startInfo = new ProcessStartInfo (clientExe, txID + " " + rxID);
  startInfo.UseShellExecute = false;    // Wymagane dla procesu potomnego.
  Process p = Process.Start (startInfo);

  tx.DisposeLocalCopyOfClientHandle();    // Zwolnienie uchwytów
  rx.DisposeLocalCopyOfClientHandle();    // zasobów niezarządzanych.

  tx.WriteByte (100);
  Console.WriteLine ("Serwer otrzymał: " + rx.ReadByte());

  p.WaitForExit();
}