namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter19.Listing19_33
{
    using AddisonWesley.Michaelis.EssentialCSharp.Shared;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    class Program
    {
        // ...
        public List<string>
          Encrypt(IEnumerable<string> data)
        {

            OrderedParallelQuery<string> parallelGroups =
            data.AsParallel().OrderBy(item => item);

            // Dowodzi, e czna liczba elementw nadal
            // jest taka sama jak na pocztku.
            if (data.Count() != parallelGroups.Sum(
                    item => item.Count()))
            {
                throw new Exception("data.Count() != parallelGroups.Sum(item => item.Count()");
            }
            // ...

            return data.AsParallel().Select(
                item => Encrypt(item)).ToList();
        }

        // ...

        private string Encrypt(string item)
        {
            Console.WriteLine($">>>>>Trwa szyfrowanie elementu '{ item }'.");
            Cryptographer cryptographer = new Cryptographer();
            string itemEncrypted = cryptographer.Encrypt(item);
            Console.WriteLine($"<<<<<Zakoczono szyfrowanie elementu '{ itemEncrypted }'.");
            return itemEncrypted;
        }

    }
}


