using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using static AddisonWesley.Michaelis.EssentialCSharp.Chapter20.Listing20_01.Tests.ProgramTests;

namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter20.Listing20_02.Tests
{
    [TestClass]
    public class ProgramTests
    {

        [TestMethod]
        public void MainVerifyOutputIncrementAndDecrement()
        {
            VerifyOutputIncrementAndDecrement(Program.Main);
        }

        /// <summary>
        /// Informuje, e operacje inkrementacji/dekrementacji nie s atomowe.
        /// WANE: Wynik moe by niepewny, jeli inkrementacji i dekrementacji przypadkowo jest tyle samo.
        /// Nie dowodzi to jednak, e operacje s zsynchronizowane (nie da si tego atwo
        /// udowodni w wyniku wykonania kodu).
        /// </summary>
        [TestMethod]
        public void UnsynchronizedIncrementAndDecrement()
        {
            bool isUnsynchronized = IsIncrementDecrementNotAtomic(Program.Main);
            if (!isUnsynchronized)
            {
                Assert.Inconclusive("Nieoczekiwanie liczba inkrementacji i dekrementacji bya taka sama, cho nie zastosowano blokad.");
            }
        }
    }
}
