namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter17.Listing17_16
{
    using System.Collections.Generic;
    using Listing17_14;

    public class BinaryTree<T> :
      IEnumerable<T>
    {
        public BinaryTree(T value)
        {
            Value = value;
        }

        #region IEnumerable<T>
        public IEnumerator<T> GetEnumerator()
        {
            // Zwracanie elementu powizanego z danym wzem.
            yield return Value;

            // Przetwarzanie kadego elementu pary.
            foreach(BinaryTree<T> tree in SubItems)
            {
                if(tree != null)
                {
                    // Poniewa kady element z pary to drzewo,
                    // naley przej po tym drzewie i zwrci kady element.
                    foreach (T item in tree)
                    {
                        yield return item;
                    }
                }
            }
        }
        #endregion IEnumerable<T>

        #region Skadowe interfejsu IEnumerable
        System.Collections.IEnumerator
            System.Collections.IEnumerable.GetEnumerator()
        {
            return GetEnumerator();
        }
        #endregion

        public T Value { get; }  // Automatycznie generowana waciwo z samym getterem (kod dla wersji C# 6.0).
        
        public Pair<BinaryTree<T>> SubItems { get; set; }
    }
}
