﻿namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter14.Listing14_19
{
    public class Thermostat
    {
        public class TemperatureArgs : System.EventArgs
        {
            public TemperatureArgs(float newTemperature)
            {
                NewTemperature = newTemperature;
            }

            public float NewTemperature
            {
                get { return _newTemperature; }
                set { _newTemperature = value; }
            }
            private float _newTemperature;
        }

        // Definicja typu danych delegata
        public delegate void TemperatureChangeHandler(
            object sender, TemperatureArgs newTemperature);

        // Definicja nadawcy zdarzeń.
        public event TemperatureChangeHandler OnTemperatureChange
        {
            add
            {
                _OnTemperatureChange = (TemperatureChangeHandler)System.Delegate.Combine(value, _OnTemperatureChange);
            }
            remove
            {
                _OnTemperatureChange = (TemperatureChangeHandler)System.Delegate.Remove(_OnTemperatureChange, value);
            }
        }
        protected TemperatureChangeHandler _OnTemperatureChange;

        public float CurrentTemperature
        {
            set
            {
                if (value != CurrentTemperature)
                {
                    _CurrentTemperature = value;
                    // Jeśli istnieją subskrybenci,
                    // należy ich powiadomić o zmianie temperatury
                    // za pomocą skierowanego do nich wywołania.
                    _OnTemperatureChange?.Invoke( // C# 6.0
                          this, new TemperatureArgs(value));
                }
            }
            get { return _CurrentTemperature; }
        }
        private float _CurrentTemperature;
    }
}