﻿namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter08.Listing08_06
{
    interface IReadableSettingsProvider
    {
        string GetSetting(string name, string defaultValue);
    }

    interface ISettingsProvider : IReadableSettingsProvider
    {
        void SetSetting(string name, string value);
    }

    class FileSettingsProvider : ISettingsProvider
    {
        #region Składowe interfejsu ISettingsProvider
        public void SetSetting(string name, string value)
        {
            // ...
        }
        #endregion

        #region Składowe interfejsu IReadableSettingsProvider
        public string GetSetting(string name, string defaultValue)
        {
            return name + defaultValue; // Zwracanie przykładowych danych.
        }
        #endregion
    }

}
