﻿namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter07
{
    using System;

    /*  *****************************************************
     *  Na potrzeby dopasowywania do wzorca zakładamy, że kod
     *  źródłowy jest niedostępny, dlatego polimorfizm jest
     *  niemożliwy.
     *  *****************************************************/
    public abstract class Storage { }
    public class Dvd : Storage
    {
        public bool IsInserted { get; set; }

        internal void Eject()
        {
            Console.WriteLine("Otwieranie napędu DVD...");
        }

    }
    public class HardDrive : Storage { }
    public class FloppyDrive : Storage { }
    public class UsbKey : Storage
    {
        public bool IsPluggedIn { get; set; }

        internal void Unload()
        {
            Console.WriteLine("Odłączanie napędu USB...");
        }
    }
}