namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter15.Listing15_25
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;

    public class Program
    {
        public static void Main()
        {
            IEnumerable<object> stuff =
                new object[] { new object(), 1, 3, 5, 7, 9,
        "\"rzecz\"", Guid.NewGuid() };
            Print("Zmienna stuff: { 0 }", stuff);
            IEnumerable<int> even = new int[] { 0, 2, 4, 6, 8 };
            Print("Parzyste liczby cakowite: {0}", even);

            IEnumerable<int> odd = stuff.OfType<int>();
            Print("Nieparzyste liczby cakowite: {0}", odd);

            IEnumerable<int> numbers = even.Union(odd);
            Print("Unia liczb parzystych i nieparzystych: {0}", numbers);

            Print("Unia z liczbami parzystymi: {0}", numbers.Union(even));
            Print("Doczenie liczb nieparzystych: {0}", numbers.Concat(odd));
            Print("Cz wsplna z parzystymi: {0}",
              numbers.Intersect(even));
            Print("Niepowtarzajce si wartoci: {0}", numbers.Concat(odd).Distinct());
            if (!numbers.SequenceEqual(
              numbers.Concat(odd).Distinct()))
            {
                throw new Exception("Nieoczekiwana nierwno.");

            }
            else
            {
                Console.WriteLine(
        @"Kolekcja ""SequenceEquals""" +
          $" {nameof(numbers)}.Concat(odd).Distinct())");
    }
            Print("Odwrcenie: {0}", numbers.Reverse());
            Print("rednia: {0}", numbers.Average());
            Print("Suma: {0}", numbers.Sum());
            Print("Maksimum: {0}", numbers.Max());
            Print("Minimum: {0}", numbers.Min());
        }

        private static void Print<T>(
                string format, IEnumerable<T> items) =>
            Console.WriteLine(format, string.Join(
                ", ", items.Select(x => x.ToString())));

        private static void Print<T>(string format, T item)
        {
            Console.WriteLine(format, item);
        }
    }
}
