﻿using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.IO;
using System.Runtime.InteropServices;

namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter07.Listing07_24.Tests
{
    [TestClass]
    public class ProgramTests
    {
        [TestMethod]
        public void EjectDvd()
        {
            string expected = $"Otwieranie napędu DVD...{Environment.NewLine}Otwarto napęd DVD!";
            IntelliTect.TestTools.Console.ConsoleAssert.Expect(
                expected, () =>
                {
                    Program.Eject(new Dvd() { IsInserted = true });
                }
            );
        }

        [TestMethod]
        public void EjectUsb()
        {
            string expected = $"Odłączanie napędu USB...{Environment.NewLine}Odłączono napęd podłączony przez USB!";
            IntelliTect.TestTools.Console.ConsoleAssert.Expect(
                expected, () =>
                    Program.Eject(new UsbKey() { IsPluggedIn = true })
            );
        }

        [TestMethod]
        [ExpectedException(typeof(InvalidOperationException))]
        public void EjectHardDrive()
        {
            string expected = $"Ostrzeżenie: Nie ma nic do zapisania{Environment.NewLine}";
            IntelliTect.TestTools.Console.ConsoleAssert.Expect(
                expected, () =>
                    Program.Eject(new HardDrive())
            );
        }

        [TestMethod][ExpectedException(typeof(ArgumentNullException))]
        public void EjectNull()
        {
            string expected = $"Ostrzeżenie: Nie ma nic do zapisania{Environment.NewLine}";
            IntelliTect.TestTools.Console.ConsoleAssert.Expect(
                expected, () =>
                    Program.Eject(null)
            );
        }
    }
}