﻿namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter10.Listing10_21
{
    using System;
    using System.IO;

    public class Program
    {
        // ...
        public static void Search()
        {
            TemporaryFileStream fileStream =
                new TemporaryFileStream();

            // Używanie obiektu typu TemporaryFileStream.
            // ...

            fileStream.Dispose();

            // ...
        }
    }

    class TemporaryFileStream : IDisposable
    {
        public TemporaryFileStream(string fileName)
        {
            File = new FileInfo(fileName);
            Stream = new FileStream(
                File.FullName, FileMode.OpenOrCreate,
                FileAccess.ReadWrite);
        }

        public TemporaryFileStream()
            : this(Path.GetTempFileName()) { }



        ~TemporaryFileStream()
        {
            Dispose(false);
        }

        public FileStream Stream { get; }
        public FileInfo File { get; }

        public void Close()
        {
            Dispose();
        }

        #region Składowe interfejsu IDisposable
        public void Dispose()
        {
            Dispose(true);

            // Wyłączenie wywołań finalizatora.
            System.GC.SuppressFinalize(this);
        }
        #endregion
        public void Dispose(bool disposing)
        {
            // Nie trzeba usuwać własnego zarządzanego obiektu
            // (z finalizatorem), jeśli metoda została wywołana przez finalizator.
            // Powodem jest to, że finalizator takich obiektów zostanie
            // (lub już został) wywołany w przetwarzanej kolejce finalizacji.
            if (disposing)
            {
                Stream?.Dispose();
            }
            File?.Delete();
        }

    }
}