﻿using System;

namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter07.Listing07_24
{
    public class Program
    {
        static public void Eject(Storage storage)
        {
            switch (storage)
            {
                case null: // Lokalizacja bloku case null nie ma znaczenia.
                    throw new ArgumentNullException(nameof(storage));
                // ** Spowoduje błąd kompilacji, ponieważ instrukcje case
                // ** poniżej będą niedostępne.
                // case Storage tempStorage:
                //   throw new Exception();
                //   break;
                case UsbKey usbKey when usbKey.IsPluggedIn:
                    usbKey.Unload();
                    Console.WriteLine("Odłączono napęd podłączony przez USB!");
                    break;
                case Dvd dvd when dvd.IsInserted:
                    dvd.Eject();
                    Console.WriteLine("Otwarto napęd DVD!");
                    break;
                case Dvd dvd when !dvd.IsInserted:
                    throw new ArgumentException(
                      "Brak płyty w napędzie DVD.", nameof(storage));
                case HardDrive hardDrive:
                    throw new InvalidOperationException();
                default:  // Lokalizacja bloku case default nie ma znaczenia.
                    throw new ArgumentException(nameof(storage));
            }
        }
    }
}
